<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
// Create layout and options section
CSF::createSection( $restlyThemeOption, array(
    'title' => esc_html__( 'Footer Settings', 'restly' ),
    'id'    => 'restly_footer_options',
    'icon'  => 'fa fa-sort-amount-asc',
) );
// Header Style
CSF::createSection( $restlyThemeOption, array(
    'parent' => 'restly_footer_options',
    'title'  => esc_html__( 'Footer Options', 'restly' ),
    'icon'   => 'fa fa-header',
    'fields' => array(
        array(
            'id'          => 'restly_footer_styles',
            'type'        => 'select',
            'title'       => esc_html__( 'Select', 'restly' ),
            'placeholder' => esc_html__( 'Select an option', 'restly' ),
            'options'     => array(
                'one'   => esc_html__( 'Footer One', 'restly' ),
                'two'   => esc_html__( 'Footer Two', 'restly' ),
                'three' => esc_html__( 'Footer Three', 'restly' ),
                'four' => esc_html__( 'Footer Four', 'restly' ),
                'five' => esc_html__( 'Footer Five', 'restly' ),
                'six' => esc_html__( 'Footer Six', 'restly' ),
                'seven' => esc_html__( 'Footer Seven', 'restly' ),
            ),
            'default'     => 'two',
            'subtitle'    => esc_html__( 'Select Your Footer', 'restly' ),
        ),
        array(
            'id'         => 'restly_ft1_top_enable',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Section', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft1_top_groups',
            'type'       => 'repeater',
            'title'      => esc_html__( 'Top Items', 'restly' ),
            'subtitle'   => esc_html__( 'Add Content for Footer two Top Section', 'restly' ),
            'dependency' => array( 'restly_footer_styles|restly_ft1_top_enable', '==|==', 'two|true', 'all' ),
            'fields'     => array(
                array(
                    'id'    => 'restly_ft1_top_label',
                    'type'  => 'text',
                    'title' => esc_html__( 'Label', 'restly' ),
                ),
                array(
                    'id'    => 'restly_ft1_top_dec',
                    'type'  => 'wp_editor',
                    'title' => esc_html__( 'Content', 'restly' ),
                ),
                array(
                    'id'    => 'restly_ft1_top_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Icon', 'restly' ),
                ),
            ),
            'default'    => array(
                array(
                    'restly_ft1_top_label' => esc_html__( 'Call us', 'restly' ),
                    'restly_ft1_top_dec'   => esc_html__( '+012-345-6789', 'restly' ),
                    'restly_ft1_top_icon'  => 'fas fa-phone-alt',
                ),
                array(
                    'restly_ft1_top_label' => esc_html__( 'Write to us', 'restly' ),
                    'restly_ft1_top_dec'   => esc_html__( 'info@example.com', 'restly' ),
                    'restly_ft1_top_icon'  => 'fas fa-envelope',
                ),
                array(
                    'restly_ft1_top_label' => esc_html__( 'Office hours', 'restly' ),
                    'restly_ft1_top_dec'   => esc_html__( 'Mon-Sat 9:00 - 7:00', 'restly' ),
                    'restly_ft1_top_icon'  => 'fas fa-clock',
                ),
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Widget CSS Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_ft1_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => 'h4.widget-title,.subscribe-widget h4.widget-title',
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft1_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => '.company-info-widget p,.company-contact-widget ul li,.company-subscribe-widget p',
            'default'    => '#ffffff',
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_ft1_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Link Color', 'restly' ),
            'output'     => '.footer-widgets-area .widget ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#b0c2d7',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CopyRight Section CSS', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_ft1_copyright_text_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Text', 'restly' ),
            'output'     => '.footer-one .copyright-area p',
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft1_copyright_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Copyrihgt Link Color', 'restly' ),
            'output'     => '.footer-one .copyright-area .social-icons ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#b0c2d7',
            ),
        ),
        array(
            'id'         => 'restly_ft1_copyright_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add CopyRight Background Color', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
            'output'     => '.footer-one .copyright-area',
            'default'    => array(
                'background-color' => '#003fb4',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Main Background Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_ft1_bg_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background color or Image for footer ', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'one', 'all' ),
            'output'     => '.footer-one .footer-widgets-area',
            'default'    => array(
                'background-color' => '#104cba',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Section CSS', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft2_top_icon',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Footer Two Top Section icon', 'restly' ),
            'output'     => '.footer-two .ft2-icon i',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'          => 'restly_ft2_top_iconbg',
            'type'        => 'color',
            'title'       => esc_html__( 'Icon Bg Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Color for Footer Two Top Section icon Background', 'restly' ),
            'output'      => '.footer-two .ft2-icon i',
            'dependency'  => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'     => '#104cba',
            'output_mode' => 'background-color',
        ),
        array(
            'id'         => 'restly_ft2_top_label',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Footer Two Top Section Label', 'restly' ),
            'output'     => '.footer-two .ft2-content label',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => '#bdc2cb',
        ),
        array(
            'id'         => 'restly_ft2_top_dec',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Footer Two Top Section Content', 'restly' ),
            'output'     => '.footer-two .ft2-content,.footer-two .ft2-content span',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft2_top_link',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Hover and Normal Color for Link Content', 'restly' ),
            'output'     => '.footer-two .ft2-content a',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#1d2c38',
            ),
        ),
        array(
            'id'          => 'restly_ft2_top_line',
            'type'        => 'color',
            'title'       => esc_html__( 'Line Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Items Line Color', 'restly' ),
            'output'      => '.footer-two .footer-top-area .ft-top-item',
            'dependency'  => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'     => '#223452',
            'output_mode' => 'border-color',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CSS Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft2_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => '.footer-two h4.widget-title,.footer-two .subscribe-widget h4.widget-title',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft2_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => '.footer-two .company-info-widget p,.footer-two .company-contact-widget ul li,.footer-two .company-subscribe-widget p',
            'default'    => '#ffffff',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft2_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'output'     => '.footer-two .company-contact-widget ul li a,.footer-two .footer-widgets-area .widget ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#104cba',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Copyright Section Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft2_copytext_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for CopyRight Text', 'restly' ),
            'output'     => '.footer-two .copyright-area p',
            'default'    => '#ffffff',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft2_copy_link',
            'type'       => 'link_color',
            'title'      => esc_html__( 'link Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Link And Social Link', 'restly' ),
            'output'     => '.footer-two .copyright-area .social-icons ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#104cba',
            ),
        ),
        array(
            'id'          => 'restly_ft2_copytext_border_css',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Color for CopyRight Border', 'restly' ),
            'output_mode' => 'border-color',
            'output'      => '.footer-two .copyright-area',
            'default'     => '#223452',
            'dependency'  => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Background Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_ft2_main_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background image or Color for Footer area', 'restly' ),
            'output'     => '.footer-two .footer-widgets-area',
            'dependency' => array( 'restly_footer_styles', '==', 'two', 'all' ),
            'default'    => array(
                'background-color' => '#091d3e',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CSS Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_ft3_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => '.footer-three h4.widget-title,.footer-three .subscribe-widget h4.widget-title',
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft3_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => '.footer-three .company-info-widget p,.footer-three .company-contact-widget ul li,.footer-three .company-subscribe-widget p',
            'default'    => '#ffffff',
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_ft3_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'output'     => '.footer-three .company-contact-widget ul li a,.footer-three .footer-widgets-area .widget ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#104cba',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Copyright Section Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_ft3_copytext_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for CopyRight Text', 'restly' ),
            'output'     => '.footer-three .copyright-area p',
            'default'    => '#ffffff',
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_ft3_copy_link',
            'type'       => 'link_color',
            'title'      => esc_html__( 'link Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Link And Social Link', 'restly' ),
            'output'     => '.footer-three .copyright-area .social-icons ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#104cba',
            ),
        ),
        array(
            'id'          => 'restly_ft3_copytext_border_css',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Color for CopyRight Border', 'restly' ),
            'output_mode' => 'border-color',
            'output'      => '.footer-three .copyright-area',
            'default'     => '#223452',
            'dependency'  => array( 'restly_footer_styles', '==', 'three', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Background Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_ft3_main_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background image or Color for Footer area', 'restly' ),
            'output'     => '.footer-three .footer-widgets-area',
            'dependency' => array( 'restly_footer_styles', '==', 'three', 'all' ),
            'default'    => array(
                'background-color' => '#091d3e',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Widget CSS Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_ft4_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => '.site-footer.footer-four h4.widget-title,.site-footer.footer-four .subscribe-widget h4.widget-title',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'default'    => '#0A1426',
        ),
        array(
            'id'         => 'restly_ft4_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => '.site-footer.footer-four .company-info-widget p,.site-footer.footer-four .company-contact-widget ul li,.site-footer.footer-four .company-subscribe-widget p,.site-footer.footer-four .mc4wp-form-fields input[type=email],.site-footer.footer-four .mc4wp-form-fields input[type=email]::placeholder',
            'default'    => '#6C727D',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_ft4_dot_css',
            'type'       => 'color',
            'title'      => esc_html__( 'List Dot Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget List Dot', 'restly' ),
            'output'     => '.site-footer.footer-four .widget.widget_nav_menu ul li a:before',
            'default'    => '#6C727D',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_ft4_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Link Color', 'restly' ),
            'output'     => '.site-footer.footer-four .footer-widgets-area .widget ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'default'    => array(
                'color' => '#6C727D',
                'hover' => '#0A1426',
            ),
        ),
        array(
            'id'         => 'restly_ft4_nesletter_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Newsletter Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background color or Image for Newsletter ', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'output'     => '.site-footer.footer-four .subscribe-widget',
            'default'    => array(
                'background-color' => '#dbe1e8',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CopyRight Section CSS', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_ft4_copyright_text_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Text', 'restly' ),
            'output'     => '.site-footer.footer-four .site-info',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'default'    => '#0A1426',
        ),
        array(
            'id'         => 'restly_ft4_copyright_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Copyrihgt Link Color', 'restly' ),
            'output'     => '.site-footer.footer-four .copyright-area .social-icons ul li a',
            'output'     => '.site-footer.footer-four .copyright-area a',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'default'    => array(
                'color' => '#0A1426',
                'hover' => '#2F97F7',
            ),
        ),
        array(
            'id'          => 'restly_ft4_copyright_border_colar',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'       => esc_html__( 'Add Copyright Border Top Color', 'restly' ),
            'output'      => '.site-footer.footer-four .copyright-area .container',
            'output_mode' => 'border-color',
            'default'    => '#dbe1e8',
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_ft4_copyright_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add CopyRight Background Color', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'output'     => '.site-footer.footer-four .copyright-area',
            'default'    => array(
                'background-color' => '#F4F7FA',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Main Background Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_ft4_bg_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background color or Image for footer ', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'four', 'all' ),
            'output'     => '.site-footer.footer-four .footer-widgets-area',
            'default'    => array(
                'background-color' => '#F4F7FA',
            ),
        ),


        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CSS Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_ft5_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => '.footer-five h4.widget-title,.footer-five .widget-title,.footer-five .subscribe-widget h4.widget-title',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
            'default'    => '#000F5C',
        ),
        array(
            'id'         => 'restly_ft5_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => '.footer-five .company-info-widget p,.footer-five .company-contact-widget ul li,.footer-five .company-subscribe-widget p',
            'default'    => '#808080',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_ft5_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'output'     => '.footer-five .company-contact-widget ul li a,.footer-five .footer-widgets-area .widget ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
            'default'    => array(
                'color' => '#333F7D',
                'hover' => '#104cba',
            ),
        ),
        
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Background Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_ft5_main_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background image or Color for Footer area', 'restly' ),
            'output'     => '.footer-five .footer-widgets-area',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
            'default'    => array(
                'background-color' => '#ffffff',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Copyright Section Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_ft5_copytext_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for CopyRight Text', 'restly' ),
            'output'     => '.footer-five .copyright-area p',
            'default'    => '#000F5C',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_ft5_copy_link',
            'type'       => 'link_color',
            'title'      => esc_html__( 'link Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Link And Menu Link', 'restly' ),
            'output'     => '.footer-five .copyright-area a',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
            'default'    => array(
                'color' => '#104cba',
                'hover' => '#000F5C',
            ),
        ),
        array(
            'id'         => 'restly_ft5_copyright_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background image or Color for copyright area', 'restly' ),
            'output'     => '.footer-five .copyright-area',
            'dependency' => array( 'restly_footer_styles', '==', 'five', 'all' ),
            'default'    => array(
                'background-color' => '#F8FBFF',
            ),
        ),
        // Footer Six
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Widget CSS Options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_ft6_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => '.footer-six h4.widget-title,.footer-six .subscribe-widget h4.widget-title, .footer-six .wp-block-group__inner-container h2,.footer-six h2.widget-title',
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft6_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => '.footer-six .company-info-widget p,.footer-six .company-contact-widget ul li,.footer-six .company-subscribe-widget p, .footer-six p, .footer-six article footer',
            'default'    => '#ffffff',
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_ft6_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Link Color', 'restly' ),
            'output'     => '.footer-six .footer-widgets-area li a,.footer-six .footer-widgets-area ul li a',
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#b0c2d7',
            ),
        ),
        array(
            'id'         => 'restly_ft6_bg_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background color or Image for footer ', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
            'background_gradient'             => true,
            'background_origin'               => true,
            'background_clip'                 => true,
            'background_blend_mode'           => true,
            'output'     => '.footer-six .footer-widgets-area',
            'default'    => array(
                'background-color' => '#104cba',
            ),
        ), 
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CopyRight Section CSS', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_ft6_copyright_text_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Text', 'restly' ),
            'output'     => '.footer-six .copyright-area p',
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
            'default'    => '#ffffff',
        ),
        array(
            'id'         => 'restly_ft6_copyright_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Copyrihgt Link Color', 'restly' ),
            'output'     => '.footer-six .copyright-area p a',
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#b0c2d7',
            ),
        ),
        array(
            'id'         => 'restly_ft6_copyright_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add CopyRight Background Color', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'six', 'all' ),
            'background_gradient'             => true,
            'background_origin'               => true,
            'background_clip'                 => true,
            'background_blend_mode'           => true,
            'output'     => '.footer-six .copyright-area',
            'default'    => array(
                'background-color' => '#003fb4',
            ),
        ),




        //////////////////////////////////////////
        /////// FOOTER SEVEN START //////////////
        ////////////////////////////////////////
        
        array(
            'type'    => 'subheading',
            'content'    => esc_html__( 'Widgets CSS options', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_ft7_title_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Title Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Title', 'restly' ),
            'output'     => array('.footer-seven .restly-footer-widgets .widget h4.widget-title','
            .footer-seven .restly-footer-widgets .widget .subscribe-widget h4.widget-title'),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_ft7_dec_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Content Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Widget Content', 'restly' ),
            'output'     => array( '.footer-seven .restly-footer-widgets .widget .company-info-widget p','.footer-seven .restly-footer-widgets .widget .company-contact-widget ul li','.footer-seven .restly-footer-widgets .widget .company-subscribe-widget p','.footer-seven .restly-footer-widgets .widget .mc4wp-form-fields input[type=email]','.footer-seven .restly-footer-widgets .widget .mc4wp-form-fields input[type=email]::placeholder','.footer-seven .restly-footer-widgets .widget p','.footer-seven .restly-footer-widgets .widget ul li','.footer-seven .restly-footer-widgets .widget' ),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_ft7_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'output'     => array( '.footer-seven .restly-footer-widgets .widget ul li a','.footer-seven .restly-footer-widgets .widget.widget_archive ul li a:before','.footer-seven .restly-footer-widgets .widget.widget_categories ul li a:before','.footer-seven .restly-footer-widgets .widget.widget_pages ul li a:before','.footer-seven .restly-footer-widgets .widget.widget_nav_menu ul li a:before','.footer-seven .restly-footer-widgets .widget a' ),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_ft7_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background for Widget Area', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
            'background_gradient'             => true,
            'background_origin'               => true,
            'background_clip'                 => true,
            'background_blend_mode'           => true,
            'output'     => '.footer-seven .footer-widgets-area',
        ),
        array(
            'type'    => 'subheading',
            'content'    => esc_html__( 'CopyRight Section CSS', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_ft6_copyright_text_css',
            'type'       => 'color',
            'title'      => esc_html__( 'Copyright Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Copyright Text', 'restly' ),
            'output'     => array('.footer-seven .copyright-area p','.footer-seven .copyright-area'),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
            
        ),
        array(
            'id'         => 'restly_ft6_copyright_link_css',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Copyrihgt Link Color', 'restly' ),
            'output'     => array('.footer-seven .copyright-area p a','.footer-seven .copyright-area a'),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_ft6_copyright_css',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add CopyRight Background Color', 'restly' ),
            'dependency' => array( 'restly_footer_styles', '==', 'seven', 'all' ),
            'background_gradient'             => true,
            'background_origin'               => true,
            'background_clip'                 => true,
            'background_blend_mode'           => true,
            'output'     => '.footer-seven .copyright-area',
        ),
    ),
) );
// End Header Style
// Widget Layout
CSF::createSection( $restlyThemeOption, array(
    'parent' => 'restly_footer_options',
    'title'  => esc_html__( 'Widget Layout', 'restly' ),
    'icon'   => 'fa fa-th',
    'fields' => array(
        array(
            'id'      => 'footer_column_layout',
            'type'    => 'image_select',
            'title'   => esc_attr__( 'Footer Widget Columns', 'restly' ),
            'options' => array(
                '12'      => get_template_directory_uri() . '/assets/image/widgets/footer_col_12.png',
                '6_6'     => get_template_directory_uri() . '/assets/image/widgets/footer_col_6_6.png',
                '4_4_4'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_4_4_4.png',
                '3_3_3_3' => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_3_3_3.png',
                '3_2_3_4' => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_2_3_4.png',
                '8_4'     => get_template_directory_uri() . '/assets/image/widgets/footer_col_8_4.png',
                '4_8'     => get_template_directory_uri() . '/assets/image/widgets/footer_col_4_8.png',
                '6_3_3'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_6_3_3.png',
                '3_3_6'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_3_6.png',
                '8_2_2'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_8_2_2.png',
                '2_2_8'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_2_2_8.png',
                '6_2_2_2' => get_template_directory_uri() . '/assets/image/widgets/footer_col_6_2_2_2.png',
                '2_2_2_6' => get_template_directory_uri() . '/assets/image/widgets/footer_col_2_2_2_6.png',
                '3_2_2_2_3' => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_2_2_2_3.jpg',
            ),
            'default' => '3_3_3_3',
            'after'   => esc_attr__( 'Select Footer Column layout View for widgets.', 'restly' ),
        ),
        array(
            'type'    => 'submessage',
            'style'   => 'info',
            'content' => esc_html__( 'Copyright', 'restly' ),
        ),
        array(
            'id'            => 'restly_copyright_text',
            'type'          => 'wp_editor',
            'title'         => esc_html__( 'Copyright Text', 'restly' ),
            'subtitle'      => esc_html__( 'Site copyright text', 'restly' ),
            'desc'          => esc_html__( 'Type site copyright text here.', 'restly' ),
            'tinymce'       => true,
            'quicktags'     => true,
            'media_buttons' => false,
            'height'        => '100px',
        ),
        array(
            'type'    => 'submessage',
            'style'   => 'info',
            'content' => esc_html__( 'Footer Social Links', 'restly' ),
            'dependency'  => array( 'restly_footer_styles', '!=', 'five', 'all' ),
        ),
        array(
            'id'       => 'restly_footer_socials',
            'type'     => 'group',
            'title'    => esc_html__( 'Footer Social Links', 'restly' ),
            'dependency'  => array( 'restly_footer_styles', '!=', 'five', 'all' ),
            'subtitle' => esc_html__( 'Add Social Links for Footer Section', 'restly' ),
            'fields'   => array(
                array(
                    'id'    => 'restly_ft_social_label',
                    'type'  => 'text',
                    'title' => esc_html__( 'Label', 'restly' ),
                ),
                array(
                    'id'    => 'restly_ft_social_link',
                    'type'  => 'text',
                    'title' => esc_html__( 'Content', 'restly' ),
                ),
                array(
                    'id'    => 'restly_ft_social_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Icon', 'restly' ),
                ),
            ),
            'default'  => array(
                array(
                    'restly_ft_social_label' => esc_html__( 'Facebook', 'restly' ),
                    'restly_ft_social_link'  => esc_html__( '#', 'restly' ),
                    'restly_ft_social_icon'  => 'fab fa-facebook-f',
                ),
                array(
                    'restly_ft_social_label' => esc_html__( 'Twitter', 'restly' ),
                    'restly_ft_social_link'  => esc_html__( '#', 'restly' ),
                    'restly_ft_social_icon'  => 'fab fa-twitter',
                ),
                array(
                    'restly_ft_social_label' => esc_html__( 'Instagram', 'restly' ),
                    'restly_ft_social_link'  => esc_html__( '#', 'restly' ),
                    'restly_ft_social_icon'  => 'fab fa-instagram',
                ),
                array(
                    'restly_ft_social_label' => esc_html__( 'Pinterest', 'restly' ),
                    'restly_ft_social_link'  => esc_html__( '#', 'restly' ),
                    'restly_ft_social_icon'  => 'fab fa-pinterest-p',
                ),
            ),
        ),
        array(
            'type'    => 'submessage',
            'style'   => 'info',
            'content' => esc_html__( 'Footer Menu', 'restly' ),
            'dependency'  => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'          => 'restly_ft5_menu_select',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Footer Menu', 'restly' ),
            'subtitle'       => esc_html__( 'Select Menu for Footer Style Five', 'restly' ),
            'placeholder' => esc_html__( 'Select an Menu', 'restly' ),
            'options'     => 'menus',
            'dependency'  => array( 'restly_footer_styles', '==', 'five', 'all' ),
        ),
    ),
) );